#include "fbgfx.bi"


Screenres 640, 480, 32


  '' Create a buffer the size of our screen.
Dim as FB.IMAGE ptr myBuf = ImageCreate( 640, 480 )

  '' Get the address of our screen's buffer.
Dim as uInteger ptr myScrPix = ScreenPtr
  '' Get the address of our pixel's buffer.
Dim as uInteger ptr myBufPix = Cast( uInteger ptr, Cast( uByte ptr, myBuf ) + Sizeof(FB.IMAGE) )


  '' Lock our page.  Fill the entire page with white.
Screenlock

  '' Alternatively, if the screen resolution's unknown, use ScreenInfo to
  '' Make this more secure
  For xVar as Integer = 0 to 639
    For yVar as Integer = 0 to 479
      myScrPix[ ( yVar * 640 ) + xVar ] = rgb(255, 255, 255)
    Next
  Next

Screenunlock
sleep


  '' Draw onto our image buffer all red.
For xVar as Integer = 0 to myBuf->Width - 1
  For yVar as Integer = 0 to myBuf->Height - 1
    myBufPix[ ( yVar * myBuf->Width ) + xVar ] = rgb(255, 0, 0)
  Next
Next

  '' Put the red buffer on the screen.
Put (0,0), myBuf, pset
sleep


/'
  ScreenPtr:
    1) Get address of screen buffer
       (remember that FBgfx uses a dummy buffer that it flips automatically)
    2) Lock page
    3) Draw onto screen address
    4) Unlock page to show buffer
  
  Image Buffer:
    1) Create an image buffer
    2) Get the address of image pixels
    3) Draw onto image pixels
       (you can use neat stuff like the buffer information to help you here)
    4) Put down Image where you please
       (another big plus!)
       
  About Drawing:
    (Y * Width) + X
    
    Every Y contains WIDTH number of pixels.  Remember that the entire screen's
    buffer is all held sequentially.  In order to reach your new Y, you have to
    skip an entire row of pixels :D
    
    
    1 Row = Width Number of Pixels (640)
    1 Column = Height Number of Pixels (480) - For Y,X drawing rather than X,Y
    
    Y = Row * Width then.
    Just add X to get the horizontal position on this row.
    
    X = Column * Height then.    
    Just add Y to get the vertical position on the column.
'/